<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/Prodotto.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    if(isset($_GET["id"])) {
        $ordine = $geecomDb->leggiSingolaRiga("geecEc_ordini",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $dataRegistrazione = date("d/m/Y",strtotime($ordine["dataOrdine"]));
    }
    
    $datiGeecomAdmin   = $geecomDb->leggiSingolaRiga("geec_prodotti",2);
    $impostazioniAdmin = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
    $linkGeecomAdmin   = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioniAdmin, $datiGeecomAdmin);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Ordine <?= $ordine["id"] ?></title>
    </head>
    <body>
    
        <main role="main" id="main" class="mt-5">
            <div class="container-fluid">
	            <div class="row">

                        <div class="col-xl-6 mx-auto d-print-table">
                                <div class="mb-3 text-right">
                                    <a class="btn btn-outline-primary d-print-none" href="javascript:void" onclick="window.print()"><i class="fas fa-print"></i>Stampa</a>
                                </div>

                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-header">
                                                    <h5 class="mb-0"> Dettagli ordine n. <?php echo $ordine["id"] ?></h5>
                                                </div>
                                                <div class="card-body">
                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Data registrazione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo $dataRegistrazione ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Ordinante</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                            <?php
                                                               if($ordine["idCliente"]!=0) {
                                                                   echo"<span class=\"align-self-center\"><b><a href=\"$linkGeecomAdmin/creaUtente.php?id={$ordine["idCliente"]}\">{$ordine["destinatario"]}</a></b></span>";
                                                               }
                                                               else {
                                                                   echo"<span class=\"align-self-center\"><b>{$ordine["destinatario"]} </b>(non registrato)</span>";
                                                               }
                                                            ?>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Metodo pagamento</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center mr-2"><?php echo $ordine["tipoPagamento"] ?></span>
                                                                <?php
                                                                    if($ordine["tipoPagamento"]=="stripe") {
                                                                        echo"<span class=\"align-self-center\">(id transazione: {$ordine["idTransazione"]})</span>";
                                                                    }
                                                                ?>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Stato</b></label>
                                                            <div class="col-sm-8">
                                                                <span class="align-self-center"><?php echo $ordine["stato"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Tipo di spedizione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo $ordine["tipoSpedizione"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Codice tracciamento</b></label>
                                                            <div class="col-sm-8">
                                                                <span class="align-self-center"><?php echo $ordine["codiceTracciamento"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Indirizzo di spedizione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo "{$ordine["indirizzoSpedizione"]}, {$ordine["citta"]}, {$ordine["capSpedizione"]}" ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Email</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <span class="align-self-center"><?php echo $ordine["email"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Telefono</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <span class="align-self-center"><?php echo $ordine["telefono"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Importo €</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo $ordine["importoTotaleOrdine"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <label  class="col-sm-4 col-form-label"><b>Tipo ricevuta</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo $ordine["tipoRicevuta"] ?></span>
                                                            </div>
                                                        </div>
                                                </div>
                                                    <?php
                                                        $parametri = array("tabella"=>"geecEc_prodottiOrdinati", "elementiPerPagina"=>250,"parametriRicerca"=>array("idCarrello"=>$ordine["idCarrello"]),"ajax"=>false);

                                                        $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneUtenti.php");
                                                        
                                                        if(isset($_GET["pag"])) {
                                                        	$ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                                        }
                                                        else {
                                                        	$ris = $ricerca->eseguiRicerca(1);
                                                        }

                                                        $colonne = array("Oggetto","Quantità","Costo unitario");
                                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                                        $tabella->setTipo("normale");
                                                        while($prodottoOrdinato = $ris->fetch_assoc()) {
                                                            $tabella->aggiungiNuovaRiga(array("<a href=\"creaProdotto.php?id={$prodottoOrdinato["idProdotto"]}\"><b>{$prodottoOrdinato["nomeProdotto"]}</b></a>",$prodottoOrdinato["quantita"],$prodottoOrdinato["prezzoUnitario"]),array());
                                                        }
                                                        $tabella->stampa();
                                                    ?>
                                            </div>
                                        </div>
                                        
                                    </div>
                            </div>
                        </div>
                        
                        <!-- Colonna principale -->
                </div>

            </div>
        </main>

        <?php 

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
        ?>
            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>
        
        <?php 
        	if(isset($_GET["redirect"]) && $_GET["redirect"]=="index") {
        		$linkRedirect = "index.php?status=230";
        	}
        	else {
        		$linkRedirect = "dettagliOrdine.php?id={$ordine["id"]}";
        	}
        ?>
        <script>
        	if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
			setTimeout(stampaFirefox, 500);
		}
		else {
			window.addEventListener("afterprint", (event) => {
				location.href="<?= $linkRedirect ?>";
			});

			setTimeout(stampa, 500);
		}

		function stampa() {
	        	window.print();
		}
		
		function stampaFirefox() {
	        	window.print();
	        	location.href="<?= $linkRedirect ?>";
		}
        </script>
    </body>
</html>